/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.util;

import com.selima.framework.util.Matcher;
import com.selima.framework.util.Transformer;
import com.selima.framework.util.Util;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ArrayUtil {
    public static final String toString(byte[] byteArray) {
        if (byteArray == null) {
            return ArrayUtil.toString((Object[])null);
        }
        int len = byteArray.length;
        Object[] ByteArray = new Byte[len];
        for (int i = 0; i < len; ++i) {
            ByteArray[i] = new Byte(byteArray[i]);
        }
        return ArrayUtil.toString(ByteArray);
    }

    public static final String toString(int[] intArray) {
        if (intArray == null) {
            return ArrayUtil.toString((Object[])null);
        }
        int len = intArray.length;
        Object[] integerArray = new Integer[len];
        for (int i = 0; i < len; ++i) {
            integerArray[i] = new Integer(intArray[i]);
        }
        return ArrayUtil.toString(integerArray);
    }

    public static final String toString(Object[] array) {
        return ArrayUtil.toString(array, "[", "]", ", ");
    }

    public static final String toString(Object[] array, String before, String after, char delimiter) {
        return ArrayUtil.toString(array, before, after, "" + delimiter);
    }

    public static final String toString(Object[] array, String before, String after, String delimiter) {
        if (array == null) {
            return "null";
        }
        StringBuffer out = new StringBuffer(before);
        for (int i = 0; i < array.length; ++i) {
            Object item = array[i];
            if (item != null && item.getClass().isArray()) {
                out.append(ArrayUtil.toString((Object[])item, before, after, delimiter));
            } else {
                out.append(array[i]);
            }
            if (i >= array.length - 1) continue;
            out.append(delimiter);
        }
        out.append(after);
        return out.toString();
    }

    public static final String toStringWithDescribedBlank(Object[] array, String before, String after, String delimiter) {
        if (array == null) {
            return "null";
        }
        StringBuffer out = new StringBuffer(before);
        for (int i = 0; i < array.length; ++i) {
            Object item = array[i];
            if (item != null && item.getClass().isArray()) {
                out.append(ArrayUtil.toString((Object[])item, before, after, delimiter));
            } else {
                String nextString = array[i].toString();
                out.append(nextString.equals("") ? "Blank (i.e. Left Empty)" : nextString);
            }
            if (i >= array.length - 1) continue;
            out.append(delimiter);
        }
        out.append(after);
        return out.toString();
    }

    public static final boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static final boolean isByteArrayEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static final <T> T[] checkNullArray(T[] array, Class<T> componentType) {
        if (array == null) {
            return (Object[])Array.newInstance(componentType, 0);
        }
        return array;
    }

    public static final <T> Set<T> getSetFromArray(T[] array) {
        HashSet<T> set = new HashSet<T>();
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    public static final String[] split(String s, char delimiter) {
        return ArrayUtil.split(s, new Character(delimiter).toString());
    }

    public static final String[] split(String s, String delimiter) {
        return ArrayUtil.split(s, delimiter, false);
    }

    public static final String[] split(String s, String delimiter, boolean regex) {
        if (s == null) {
            return new String[0];
        }
        if (Util.isEmpty(s)) {
            return new String[]{s};
        }
        String delimiterRegex = regex ? delimiter : "\\Q" + delimiter + "\\E";
        Object[] split = s.split(delimiterRegex);
        int delimsOnTailCounter = 0;
        int delimLen = delimiter.length();
        for (int i = s.length() - delimLen; i >= 0 && s.substring(i, i + delimLen).equals(delimiter); i -= delimLen) {
            ++delimsOnTailCounter;
        }
        if (delimsOnTailCounter > 0) {
            if (s.length() == delimsOnTailCounter * delimLen) {
                ++delimsOnTailCounter;
            }
            Object[] extSplit = new String[split.length + delimsOnTailCounter];
            System.arraycopy(split, 0, extSplit, 0, split.length);
            Arrays.fill(extSplit, split.length, extSplit.length, "");
            split = extSplit;
        }
        return split;
    }

    public static final String[] splitAndTrim(String s, String delimiter) {
        String[] split = ArrayUtil.split(s, delimiter);
        int len = split.length;
        for (int i = 0; i < len; ++i) {
            split[i] = split[i].trim();
        }
        return split;
    }

    public static final Object[] extendArray(Object[] array, Object toBeAdded) {
        int len = array.length;
        Object[] extArray = (Object[])Array.newInstance(array.getClass().getComponentType(), len + 1);
        System.arraycopy(array, 0, extArray, 0, len);
        extArray[len] = toBeAdded;
        return extArray;
    }

    public static final <T> T[] trim(T[] array) {
        return ArrayUtil.trim(array, 1);
    }

    public static final <T> T[] trim(T[] array, int trimLength) {
        int originaLength = array.length;
        if (trimLength < 0 || trimLength > originaLength) {
            throw new IllegalArgumentException("" + trimLength);
        }
        int trimmedLength = originaLength - trimLength;
        Object[] trimmedArray = (Object[])Array.newInstance(array.getClass().getComponentType(), trimmedLength);
        System.arraycopy(array, 0, trimmedArray, 0, trimmedLength);
        return trimmedArray;
    }

    public static final int findInNthElement(Object[][] array, Object item, final int index) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(Object object, Object OneDimArray) {
                boolean result = object.equals(((Object[])OneDimArray)[index]);
                return result;
            }
        };
        return ArrayUtil.find((Object[])array, item, matcher);
    }

    public static final int find(Object[] array, Object item) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(Object o1, Object o2) {
                return Util.equals(o1, o2);
            }
        };
        return ArrayUtil.find(array, item, matcher);
    }

    public static final int find(Object[] array, Object item, Matcher matcher) {
        for (int i = 0; i < array.length; ++i) {
            if (!matcher.match(item, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static final int find(int[] array, int item) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != item) continue;
            return i;
        }
        return -1;
    }

    public static final <T> T[] insert(T[] array, T object, int position, Class<T> componentType) {
        int resultLen = array.length + 1;
        Object[] result = (Object[])Array.newInstance(componentType, resultLen);
        System.arraycopy(array, 0, result, 0, position);
        result[position] = object;
        System.arraycopy(array, position, result, position + 1, resultLen - position - 1);
        return result;
    }

    public static final <T> T[] remove(T[] array, T element) {
        int position = ArrayUtil.find(array, element);
        if (position < 0) {
            return array;
        }
        return ArrayUtil.remove(array, position);
    }

    public static final <T> T[] remove(T[] array, int position) {
        int resultLen = array.length - 1;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), resultLen);
        System.arraycopy(array, 0, result, 0, position);
        System.arraycopy(array, position + 1, result, position, resultLen - position);
        return result;
    }

    public static final byte[] join(byte[] array1, byte[] array2) {
        if (array2 == null) {
            array2 = new byte[]{};
        }
        int len1 = array1.length;
        int len2 = array2.length;
        byte[] out = new byte[len1 + len2];
        System.arraycopy(array1, 0, out, 0, len1);
        System.arraycopy(array2, 0, out, len1, len2);
        return out;
    }

    public static final <T> T[] join(T[] array1, T[] array2) {
        Class<?> componentType = array1.getClass().getComponentType();
        return ArrayUtil.join(array1, array2, componentType);
    }

    public static final <T> T[] join(T[] array1, T[] array2, T[] outputType) {
        Class<?> componentType = outputType.getClass().getComponentType();
        return ArrayUtil.join(array1, array2, componentType);
    }

    public static final <T> T[] join(T[] array1, T[] array2, Class componentType) {
        if (array2 == null) {
            array2 = (Object[])Array.newInstance(componentType, 0);
        }
        int len1 = array1.length;
        int len2 = array2.length;
        Object[] out = (Object[])Array.newInstance(componentType, len1 + len2);
        System.arraycopy(array1, 0, out, 0, len1);
        System.arraycopy(array2, 0, out, len1, len2);
        return out;
    }

    public static final <T> T[] append(T[] array, T item) {
        Object[] itemInArray = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
        itemInArray[0] = item;
        return ArrayUtil.join(array, itemInArray);
    }

    public static final <T> T[] prepend(T item, T[] array) {
        Object[] itemInArray = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
        itemInArray[0] = item;
        return ArrayUtil.join(itemInArray, array);
    }

    public static final <T> Object[] transform(T[] array, Transformer<T> transformer, Class componentType) {
        if (array == null) {
            return null;
        }
        int len = array.length;
        Object[] transformedArray = (Object[])Array.newInstance(componentType, len);
        for (int i = 0; i < len; ++i) {
            transformedArray[i] = transformer.transform(array[i]);
        }
        return transformedArray;
    }

    public static final Object[] clone(Object[] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
        System.arraycopy(array, 0, newArray, 0, length);
        return newArray;
    }

    public static final Object[][] transpone(Object[][] array) {
        if (ArrayUtil.isEmpty((Object[])array)) {
            return array;
        }
        int lenX = array.length;
        int lenY = array[0].length;
        Object[][] transponedArray = new Object[lenY][lenX];
        for (int i = 0; i < lenX; ++i) {
            for (int j = 0; j < lenY; ++j) {
                transponedArray[j][i] = array[i][j];
            }
        }
        return transponedArray;
    }

    public static final int[] toInts(List<Integer> in) {
        int length = in.size();
        int[] out = new int[length];
        for (int i = 0; i < length; ++i) {
            out[i] = in.get(i);
        }
        return out;
    }

    public static final <T> T[] union(T[] array1, T[] array2) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(array1));
        if (array2 != null) {
            for (T t : array2) {
                if (list.contains(t)) continue;
                list.add(t);
            }
        }
        return list.toArray((Object[])Array.newInstance(array1.getClass().getComponentType(), 0));
    }

    public static final <T> T[] adjust(T[] array, int length, T paddingValue) {
        Object[] adjustedArray = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
        int originalLength = array.length;
        for (int i = 0; i < length; ++i) {
            adjustedArray[i] = i < originalLength ? array[i] : paddingValue;
        }
        return adjustedArray;
    }

    public static final <T> T[] project(T[][] array, int columnIndex) {
        if (array == null) {
            return null;
        }
        int len = array.length;
        Class<?> componentType = array.getClass().getComponentType().getComponentType();
        Object[] projection = (Object[])Array.newInstance(componentType, len);
        for (int i = 0; i < len; ++i) {
            projection[i] = array[i][columnIndex];
        }
        return projection;
    }

    public static final <T> T[] narrow(Object[] source, Class<T> targetComponentType) {
        if (source == null) {
            return null;
        }
        int len = source.length;
        Object[] result = (Object[])Array.newInstance(targetComponentType, len);
        System.arraycopy(source, 0, result, 0, len);
        return result;
    }

    public static final String[] removeEmptyElements(String[] array) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : array) {
            if (Util.isEmpty(s)) continue;
            result.add(s);
        }
        return result.toArray(new String[0]);
    }

    public static final <T> T last(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException();
        }
        return array[array.length - 1];
    }

    public static final <T> ArrayList<T> toArrayList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }
}

