/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.threading;

import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.IThreadPoolFactory;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.threading.ThreadPool;

public class ThreadPoolFactory
implements IThreadPoolFactory {
    protected ThreadPool threadPool;
    private static IThreadPoolFactory instance;

    public ThreadPoolFactory() {
        this(null);
    }

    public ThreadPoolFactory(BackendWork bwork) {
        if (ThreadPoolFactory.getInstance() == null) {
            ThreadPoolFactory.setInstance(this);
        }
        this.threadPool = new ThreadPool(bwork);
    }

    @Override
    public ISubmitter getSubmitter(final String threadName) {
        return new ISubmitter(){

            @Override
            public SwingOperationHandle submitWork(BackendWork work) {
                return ThreadPoolFactory.this.threadPool.submitWork(work, threadName);
            }
        };
    }

    @Override
    public void shutDown() {
        this.threadPool.shutDown();
    }

    @Override
    public void restart() {
        this.threadPool.restart();
    }

    @Override
    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public static IThreadPoolFactory getInstance() {
        return instance;
    }

    protected static void setInstance(IThreadPoolFactory factory) {
        instance = factory;
    }

    public static void removeInstance() {
        instance = null;
    }
}

