/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.threading;

import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.OperationHandleImpl;
import com.selima.framework.threading.Semaphor;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.bag.HashBag;

public class ThreadPool {
    private AutomaticDispose automaticDispose = new AutomaticDispose();
    public static final long DISPOSE_TIMEOUT = 120000L;
    private Semaphor semaphor = new Semaphor();
    private Map<String, BackgroundThread> threadMap = new Hashtable<String, BackgroundThread>();
    private volatile boolean isActive = true;
    private ThreadGroup backendThreadGroup = new ThreadGroup("Backend Threads of " + this);

    public ThreadPool(BackendWork bwork) {
        if (bwork != null) {
            this.submitPrivilegedWork(new InitializationWork(bwork, "Privileged Thread"));
        }
    }

    public SwingOperationHandle submitWork(BackendWork bwork, String threadName) {
        return this.submitWork(bwork, threadName, false);
    }

    public SwingOperationHandle submitPrivilegedWork(BackendWork bwork) {
        return this.submitWork(bwork, "Privileged Thread", true);
    }

    public void shutDown() {
        LogAPI.logFine("Shutdown of ThreadPool");
        this.isActive = false;
        this.backendThreadGroup.interrupt();
        for (BackgroundThread thread : this.threadMap.values()) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                LogAPI.logSevere(e);
            }
        }
        this.threadMap.clear();
    }

    public synchronized void disposeThread(String threadName) {
        BackgroundThread thread = this.threadMap.remove(threadName);
        if (thread != null) {
            thread.interrupt();
        }
        LogAPI.logInfo("Disposed Background Thread ''{0}''", threadName);
    }

    public synchronized void replaceThread(String threadName) {
        BackgroundThread oldThread = this.threadMap.remove(threadName);
        if (oldThread == null) {
            return;
        }
        oldThread.interrupt();
        BackgroundThread thread = new BackgroundThread(oldThread);
        this.threadMap.put(threadName, thread);
        thread.start();
    }

    public String[] getThreadNames() {
        return this.threadMap.keySet().toArray(new String[this.threadMap.size()]);
    }

    public int getWorkLoad(String threadName) {
        return this.allocateBackgroundThread(threadName).getWorkLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwingOperationHandle submitWork(BackendWork bwork, String threadName, boolean privileged) {
        this.automaticDispose.markUsed(threadName);
        try {
            LogAPI.logFinest("Submitting task ''{0}'' to thread ''{1}''", new Object[]{bwork.getName(), threadName});
            OperationHandleImpl handle = new OperationHandleImpl();
            if (this.isActive) {
                try {
                    if (privileged) {
                        this.semaphor.openWriteLock();
                    }
                    BackgroundThread thread = this.allocateBackgroundThread(threadName);
                    thread.pushWork(new HandleWorkPair(handle, bwork, privileged));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LogAPI.logWarning("Task ''{0}'' submitted to ''{1}'' have been interrupted while waiting for thread", new Object[]{bwork.getName(), threadName});
                    handle.setFailure(new CanceledException("Submitting thread interrupted"));
                    handle.finished();
                }
            } else {
                LogAPI.logWarning("Task ''{0}'' submitted to ''{1}'' have been refused because of shutdown ", new Object[]{bwork.getName(), threadName});
                handle.setFailure(new CanceledException("ThreadPool shutting down"));
                handle.finished();
            }
            OperationHandleImpl operationHandleImpl = handle;
            return operationHandleImpl;
        }
        finally {
            this.automaticDispose.markUnused(threadName);
        }
    }

    private synchronized BackgroundThread allocateBackgroundThread(String threadName) {
        BackgroundThread result = this.threadMap.get(threadName);
        if (result == null) {
            result = new BackgroundThread(threadName);
            this.threadMap.put(threadName, result);
            result.start();
        }
        return result;
    }

    public void restart() {
        this.isActive = true;
    }

    private class AutomaticDispose {
        Bag bag = new HashBag();

        private AutomaticDispose() {
        }

        synchronized void markUsed(String id) {
            this.bag.add((Object)id);
        }

        synchronized void markUnused(String id) {
            this.bag.remove((Object)id);
        }

        synchronized boolean disposeIfUnused(String id) {
            if (this.bag.getCount((Object)id) == 0) {
                ThreadPool.this.disposeThread(id);
                return true;
            }
            return false;
        }
    }

    private class BackgroundThread
    extends Thread {
        private LinkedList<HandleWorkPair> workList;
        private volatile OperationHandleImpl handle;

        BackgroundThread(String name) {
            super(ThreadPool.this.backendThreadGroup, name);
            this.workList = new LinkedList();
            this.setPriority(1);
            LogAPI.logInfo("Created Background Thread ''{0}''", name);
        }

        BackgroundThread(BackgroundThread deadThread) {
            this(deadThread.getName());
            this.workList.addAll(deadThread.workList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: while (true) {
                try {
                    do {
                        HandleWorkPair pair;
                        try {
                            this.handle = null;
                            pair = this.pullWork();
                            this.handle = pair.handle;
                            if (!pair.isPrivileged) {
                                ThreadPool.this.semaphor.openReadlock();
                            }
                            LogAPI.logFiner("Started processing of task ''{0}''", pair.work.getName());
                        }
                        catch (InterruptedException e1) {
                            LogAPI.logFine("Interrupted while waiting for task");
                            break block18;
                        }
                        try {
                            try {
                                this.handle.checkCancelRequest();
                                LogAPI.logFiner("Invoking backend processing for task ''{0}''", pair.work.getName());
                                if (Thread.currentThread().isInterrupted()) {
                                    throw new InterruptedException();
                                }
                                pair.work.invokeBackend(pair.handle);
                            }
                            catch (CanceledException e) {
                                LogAPI.logFine(e.toString());
                                pair.handle.setFailure(e);
                            }
                            catch (InterruptedException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                if (e instanceof BackendException && (((BackendException)e).isAlert() || ((BackendException)e).isRejection())) {
                                    LogAPI.logWarning(pair.fillStackTrace(e));
                                } else {
                                    LogAPI.logSevere(pair.fillStackTrace(e));
                                }
                                pair.handle.setFailure(e);
                            }
                            LogAPI.logFiner("Invoking swing processing for task ''{0}''", pair.work.getName());
                            if (Thread.currentThread().isInterrupted()) {
                                throw new InterruptedException();
                            }
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        pair.work.invokeSwing(pair.handle);
                                    }
                                });
                            }
                            catch (InvocationTargetException e) {
                                LogAPI.logSevere(pair.fillStackTrace(e.getCause()));
                            }
                            finally {
                                LogAPI.logFiner("Finished processing for task ''{0}''", pair.work.getName());
                                pair.handle.finished();
                            }
                        }
                        catch (InterruptedException ignore) {
                            LogAPI.logFine("Interrupted while processing task ''{0}''", pair.work.getName());
                            break block18;
                        }
                        finally {
                            if (pair.isPrivileged) {
                                ThreadPool.this.semaphor.closeWriteLock();
                            } else {
                                ThreadPool.this.semaphor.closeReadLock();
                            }
                        }
                    } while (!this.isInterrupted());
                }
                catch (RuntimeException e) {
                    LogAPI.logSevere(e);
                    continue;
                }
                break;
            }
            this.handle = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pushWork(HandleWorkPair work) {
            LinkedList<HandleWorkPair> linkedList = this.workList;
            synchronized (linkedList) {
                this.workList.add(work);
                this.workList.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HandleWorkPair pullWork() throws InterruptedException {
            HandleWorkPair result = null;
            LinkedList<HandleWorkPair> linkedList = this.workList;
            synchronized (linkedList) {
                while (this.workList.isEmpty()) {
                    this.workList.wait(120000L);
                    if (!this.workList.isEmpty()) continue;
                    ThreadPool.this.automaticDispose.disposeIfUnused(this.getName());
                }
                result = this.workList.remove(0);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getWorkLoad() {
            LinkedList<HandleWorkPair> linkedList = this.workList;
            synchronized (linkedList) {
                return this.workList.size();
            }
        }
    }

    private class InitializationWork
    implements BackendWork {
        private BackendWork bwork;
        private String threadName;

        InitializationWork(BackendWork bwork, String threadName) {
            this.bwork = bwork;
            this.threadName = threadName;
        }

        @Override
        public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
            this.bwork.invokeBackend(handle);
        }

        @Override
        public void invokeSwing(SwingOperationHandle handle) {
            try {
                this.bwork.invokeSwing(handle);
            }
            finally {
                ThreadPool.this.disposeThread(this.threadName);
            }
        }

        @Override
        public String getName() {
            return this.bwork.getName();
        }
    }

    private static class HandleWorkPair {
        StackTraceElement[] stackTrace;
        OperationHandleImpl handle;
        BackendWork work;
        boolean isPrivileged;

        HandleWorkPair(OperationHandleImpl handle, BackendWork work, boolean privileged) {
            this.isPrivileged = privileged;
            this.handle = handle;
            this.work = work;
            if (this.getClass().desiredAssertionStatus()) {
                this.stackTrace = Thread.currentThread().getStackTrace();
            }
        }

        public String toString() {
            return "HandleWorkPair:" + this.work.getName() + ":" + this.hashCode();
        }

        public Throwable fillStackTrace(Throwable tw) {
            if (this.stackTrace != null) {
                StackTraceElement[] deeper = tw.getStackTrace();
                StackTraceElement[] result = new StackTraceElement[deeper.length + this.stackTrace.length];
                System.arraycopy(deeper, 0, result, 0, deeper.length);
                System.arraycopy(this.stackTrace, 0, result, deeper.length, this.stackTrace.length);
                tw.setStackTrace(result);
            }
            return tw;
        }
    }
}

