/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.threading;

import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.ITestingThreadFactory;
import com.selima.framework.threading.IThreadPoolFactory;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.threading.ThreadPool;
import com.selima.framework.threading.ThreadPoolFactory;
import com.selima.framework.threading.WorkHandle;
import com.selima.framework.threading.WorkSelector;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class TestingThreadFactory
implements ITestingThreadFactory {
    private Map<WorkSelector, WorkHandleImpl> selectorMap = new IdentityHashMap<WorkSelector, WorkHandleImpl>();
    private Map<BackendWork, WorkHandleImpl> workMap = Collections.synchronizedMap(new IdentityHashMap());
    private IThreadPoolFactory coreFactory;
    private static final long TEST_TIMEOUT = 30000L;
    private static final long APP_TIMEOUT = 60000L;

    public TestingThreadFactory(IThreadPoolFactory factory) {
        this.coreFactory = factory;
    }

    @Override
    public synchronized void registerSelector(WorkSelector selector) {
        this.register(selector);
    }

    @Override
    public WorkHandle interceptWork(WorkSelector selector) {
        WorkHandleImpl result = this.waitForIntercept(selector);
        result.interceptionEvent();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilBackendWorkProcessed(String threadName) throws InterruptedException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Method cannot be invoked in EventDispatchThread";
        Object gate = new Object();
        while (true) {
            NotifyingBackendWork backendWork = new NotifyingBackendWork(gate, threadName);
            this.coreFactory.getSubmitter(threadName).submitWork(backendWork);
            Object object = gate;
            synchronized (object) {
                if (backendWork.fired) {
                    break;
                }
                gate.wait(60000L);
                if (backendWork.workLoad <= 0) {
                    break;
                }
            }
        }
    }

    @Override
    public void waitUntilBackendWorkProcessed() throws InterruptedException {
        String[] names = this.getThreadPool().getThreadNames();
        for (int i = 0; i < names.length; ++i) {
            this.waitUntilBackendWorkProcessed(names[i]);
        }
    }

    public static ITestingThreadFactory getTestingInstance() {
        if (!(ThreadPoolFactory.getInstance() instanceof ITestingThreadFactory)) {
            throw new AssertionError((Object)"TestingThreadFactory not installed");
        }
        return (ITestingThreadFactory)ThreadPoolFactory.getInstance();
    }

    @Override
    public ISubmitter getSubmitter(String threadName) {
        ISubmitter submitter = this.coreFactory.getSubmitter(threadName);
        return new SubmitWrapper(submitter, threadName);
    }

    @Override
    public void shutDown() {
        this.coreFactory.shutDown();
    }

    @Override
    public void restart() {
        this.coreFactory.restart();
    }

    @Override
    public ThreadPool getThreadPool() {
        return this.coreFactory.getThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkHandleImpl waitForIntercept(WorkSelector selector) {
        Map<WorkSelector, WorkHandleImpl> map;
        WorkHandleImpl handle = null;
        long time = System.currentTimeMillis();
        while (true) {
            map = this.selectorMap;
            synchronized (map) {
                if (this.selectorMap.get(selector) != null) {
                    break;
                }
            }
            map = selector;
            synchronized (map) {
                try {
                    selector.wait(60000L);
                    if (time + 60000L < System.currentTimeMillis()) {
                        throw new AssertionError((Object)"Timeout exceeded");
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        map = this.selectorMap;
        synchronized (map) {
            handle = this.selectorMap.remove(selector);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(WorkSelector selector) {
        Map<WorkSelector, WorkHandleImpl> map = this.selectorMap;
        synchronized (map) {
            this.selectorMap.put(selector, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean interceptBackendWork(BackendWork work, String threadName) {
        WorkSelector selector = null;
        WorkHandleImpl handle = null;
        Object object = this.selectorMap;
        synchronized (object) {
            selector = this.interceptingSelector(work, threadName);
            if (selector != null) {
                handle = new WorkHandleImpl(work, selector);
                this.selectorMap.put(selector, handle);
            }
        }
        if (selector != null) {
            object = selector;
            synchronized (object) {
                selector.notifyAll();
            }
            this.workMap.put(work, handle);
            return true;
        }
        return false;
    }

    private WorkSelector interceptingSelector(BackendWork work, String threadName) {
        String workName = work.getName();
        for (WorkSelector selector : this.selectorMap.keySet()) {
            if (!selector.acceptThread(threadName) || !selector.acceptWork(workName) || this.selectorMap.get(selector) != null) continue;
            return selector;
        }
        return null;
    }

    private class WorkHandleImpl
    implements WorkHandle {
        private static final int NOT_INTERCEPTED = 0;
        private static final int INTERCEPTED = 1;
        private static final int BEFORE_BACKEND = 2;
        private static final int BACKEND = 3;
        private static final int AFTER_BACKEND = 4;
        private static final int SWING = 5;
        private static final int AFTER_SWING = 6;
        private static final int FINISH = 7;
        private static final int CANCEL = 8;
        private int state = 0;
        private WorkSelector selector;
        private BackendWork backendWork;
        private SwingOperationHandle swingHandle;

        WorkHandleImpl(BackendWork backendWork, WorkSelector selector) {
            this.backendWork = backendWork;
            this.selector = selector;
        }

        @Override
        public SwingOperationHandle getOperationHandle() {
            return this.swingHandle;
        }

        @Override
        public synchronized void waitBeforeBackend() {
            this.waitForState(2, 60000L);
        }

        @Override
        public synchronized void waitAfterBackend() {
            this.waitForState(4, 60000L);
        }

        @Override
        public synchronized void waitAfterSwing() {
            this.waitForState(6, 60000L);
        }

        public synchronized void waitBeforeBackend(long timeout) {
            this.waitForState(2, timeout);
        }

        public synchronized void waitAfterBackend(long timeout) {
            this.waitForState(4, timeout);
        }

        public synchronized void waitAfterSwing(long timeout) {
            this.waitForState(6, timeout);
        }

        @Override
        public synchronized void continueTask() {
            switch (this.state) {
                case 2: {
                    this.setState(3);
                    break;
                }
                case 4: {
                    this.setState(5);
                    break;
                }
                case 6: {
                    this.setState(7);
                }
            }
        }

        @Override
        public synchronized void cancelStepping() {
            this.setState(8);
        }

        @Override
        public BackendWork getBackendWork() {
            return this.backendWork;
        }

        @Override
        public WorkSelector getSelector() {
            return this.selector;
        }

        void setSwingOperationHandle(SwingOperationHandle sh) {
            this.swingHandle = sh;
        }

        synchronized void blockUntilIntercepted() {
            this.waitForState(1, 30000L);
        }

        synchronized void interceptionEvent() {
            this.setState(1);
        }

        synchronized void beforeBackendEvent() {
            if (this.selector.stopBeforeBackend()) {
                this.setState(2);
                this.waitForState(3, 30000L);
            } else {
                this.setState(3);
            }
        }

        synchronized void afterBackendEvent() {
            if (this.selector.stopAfterBackend()) {
                this.setState(4);
                this.waitForState(5, 30000L);
            } else {
                this.setState(5);
            }
        }

        synchronized void afterSwingEvent() {
            if (this.selector.stopAfterSwing()) {
                this.setState(6);
                this.waitForState(7, 30000L);
            } else {
                this.setState(7);
            }
        }

        private void waitForState(int desiredState, long timeout) {
            long time = System.currentTimeMillis();
            while (this.state < desiredState && !Thread.currentThread().isInterrupted()) {
                try {
                    this.wait(timeout);
                    if (this.state < desiredState && System.currentTimeMillis() > time + timeout) {
                        throw new AssertionError((Object)"Timeout exceeded");
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void setState(int desiredState) {
            if (this.state != 8) {
                this.state = desiredState;
                this.notifyAll();
            }
        }
    }

    private class WorkWrapper
    implements BackendWork {
        private BackendWork work;

        WorkWrapper(BackendWork work) {
            this.work = work;
        }

        @Override
        public String getName() {
            return this.work.getName();
        }

        @Override
        public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
            WorkHandleImpl workHandle = (WorkHandleImpl)TestingThreadFactory.this.workMap.get(this.work);
            workHandle.blockUntilIntercepted();
            workHandle.beforeBackendEvent();
            try {
                this.work.invokeBackend(handle);
            }
            finally {
                workHandle.afterBackendEvent();
            }
        }

        @Override
        public void invokeSwing(SwingOperationHandle handle) {
            try {
                this.work.invokeSwing(handle);
            }
            finally {
                WorkHandleImpl workHandle = (WorkHandleImpl)TestingThreadFactory.this.workMap.remove(this.work);
                workHandle.afterSwingEvent();
            }
        }
    }

    private class SubmitWrapper
    implements ISubmitter {
        private String threadName;
        private ISubmitter submitter;

        SubmitWrapper(ISubmitter submitter, String threadName) {
            this.submitter = submitter;
            this.threadName = threadName;
        }

        @Override
        public SwingOperationHandle submitWork(BackendWork work) {
            if (TestingThreadFactory.this.interceptBackendWork(work, this.threadName)) {
                SwingOperationHandle swingHandle = this.submitter.submitWork(new WorkWrapper(work));
                WorkHandleImpl workHandle = (WorkHandleImpl)TestingThreadFactory.this.workMap.get(work);
                workHandle.setSwingOperationHandle(swingHandle);
                return swingHandle;
            }
            return this.submitter.submitWork(work);
        }
    }

    private class NotifyingBackendWork
    implements BackendWork {
        int workLoad = -1;
        private Object monitor;
        private String threadName;
        boolean fired;

        public NotifyingBackendWork(Object monitor, String threadName) {
            this.monitor = monitor;
            this.threadName = threadName;
        }

        @Override
        public String getName() {
            return "TestingThreadFactory.waitUntilBackendWorkProcessed";
        }

        @Override
        public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invokeSwing(SwingOperationHandle handle) {
            Object object = this.monitor;
            synchronized (object) {
                this.workLoad = TestingThreadFactory.this.coreFactory.getThreadPool().getWorkLoad(this.threadName);
                this.fired = true;
                this.monitor.notify();
            }
        }
    }
}

