/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.threading;

import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class OperationHandleImpl
implements BackendOperationHandle,
SwingOperationHandle {
    private Object result;
    private Throwable failure;
    private volatile boolean cancelRequest;
    private volatile boolean done;
    private volatile SecondaryLoop secondaryLoop;

    @Override
    public boolean isFinished() {
        return this.done;
    }

    @Override
    public void cancel() {
        this.cancelRequest = true;
    }

    @Override
    public void waitForFinish() throws InterruptedException {
        this.waitForFinish(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForFinish(long millis) throws InterruptedException {
        OperationHandleImpl operationHandleImpl = this;
        synchronized (operationHandleImpl) {
            if (!this.done) {
                if (SwingUtilities.isEventDispatchThread()) {
                    EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    this.secondaryLoop = eventQueue.createSecondaryLoop();
                    if (millis < Integer.MAX_VALUE) {
                        Timer timer = new Timer((int)millis, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                OperationHandleImpl.this.secondaryLoop.exit();
                            }
                        });
                        timer.setRepeats(false);
                        timer.start();
                    }
                } else if (millis == Long.MAX_VALUE) {
                    this.wait();
                } else if (millis > 0L) {
                    this.wait(millis);
                }
            }
        }
        if (this.secondaryLoop != null && !this.done && !this.cancelRequest) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (OperationHandleImpl.this.done || OperationHandleImpl.this.cancelRequest) {
                        OperationHandleImpl.this.secondaryLoop.exit();
                    }
                }
            });
            this.secondaryLoop.enter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished() {
        OperationHandleImpl operationHandleImpl = this;
        synchronized (operationHandleImpl) {
            this.done = true;
            this.notifyAll();
        }
        if (this.secondaryLoop != null) {
            this.secondaryLoop.exit();
        }
    }

    @Override
    public void checkCancelRequest() throws CanceledException {
        if (this.cancelRequest) {
            throw new CanceledException("Operation canceled by user");
        }
    }

    @Override
    public Throwable getFailure() {
        return this.failure;
    }

    @Override
    public void setFailure(Throwable failure) {
        this.failure = failure;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }
}

