/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.threading;

import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.BackendWorkEvent;
import com.selima.framework.threading.BackendWorkEventListener;
import com.selima.framework.threading.BackendWorkEventSource;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.SwingOperationHandle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class NotifyingSubmitter
implements ISubmitter,
BackendWorkEventSource {
    private List<BackendWorkEventListener> listeners;
    private ISubmitter submitter;

    public NotifyingSubmitter(ISubmitter submitter) {
        this.submitter = submitter;
        this.listeners = new ArrayList<BackendWorkEventListener>();
    }

    public NotifyingSubmitter(ISubmitter submitter, BackendWorkEventListener listener) {
        this(submitter);
        this.addBackendWorkEventListener(listener);
    }

    @Override
    public void addBackendWorkEventListener(BackendWorkEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeBackendWorkEventListener(BackendWorkEventListener listener) {
        this.listeners.remove(listener);
    }

    private void publishEvent(BackendWorkEvent event) {
        for (BackendWorkEventListener listener : this.listeners) {
            if ("Started".equals(event.getType())) {
                listener.startingEvent(event);
                continue;
            }
            listener.finishningEvent(event);
        }
    }

    @Override
    public SwingOperationHandle submitWork(BackendWork work) {
        BackendWorkWrapper wrapperWork = new BackendWorkWrapper(work);
        SwingOperationHandle result = this.submitter.submitWork(wrapperWork);
        if (result != null) {
            wrapperWork.publishStartEvent(result);
        }
        return result;
    }

    class BackendWorkWrapper
    implements BackendWork {
        private BackendWork work;
        private boolean startEventPublished;
        private Object startEventGate = new Object();

        BackendWorkWrapper(BackendWork work) {
            this.work = work;
        }

        @Override
        public String getName() {
            return this.work.getName();
        }

        @Override
        public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
            this.waitForPublishStartedEvent();
            this.work.invokeBackend(handle);
        }

        @Override
        public void invokeSwing(SwingOperationHandle handle) {
            try {
                this.work.invokeSwing(handle);
            }
            finally {
                NotifyingSubmitter.this.publishEvent(new BackendWorkEvent("Finished", this.work, handle));
            }
        }

        void publishStartEvent(SwingOperationHandle handle) {
            final BackendWorkEvent event = new BackendWorkEvent("Started", this.work, handle);
            if (SwingUtilities.isEventDispatchThread()) {
                NotifyingSubmitter.this.publishEvent(event);
                this.notifyForPublishStartEvent();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NotifyingSubmitter.this.publishEvent(event);
                        BackendWorkWrapper.this.notifyForPublishStartEvent();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyForPublishStartEvent() {
            Object object = this.startEventGate;
            synchronized (object) {
                this.startEventPublished = true;
                this.startEventGate.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForPublishStartedEvent() throws InterruptedException {
            Object object = this.startEventGate;
            synchronized (object) {
                if (!this.startEventPublished) {
                    this.startEventGate.wait();
                }
            }
        }
    }
}

