/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.threading;

import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BackendWorkDelegator
implements BackendWork {
    private static final Class[][] BACKEND_SIGNATURES = new Class[][]{{BackendOperationHandle.class}, {BackendOperationHandle.class, Object.class}, {BackendOperationHandle.class, Object.class, Object.class}, {BackendOperationHandle.class, Object.class, Object.class, Object.class}};
    private static final Class[][] SWING_SIGNATURES = new Class[][]{{SwingOperationHandle.class}, {SwingOperationHandle.class, Object.class}, {SwingOperationHandle.class, Object.class, Object.class}, {SwingOperationHandle.class, Object.class, Object.class, Object.class}};
    private String name;
    private String backendMethod;
    private String swingMethod;
    protected Object delegate;
    protected Object[] data;

    public BackendWorkDelegator(Object delegate, String backendMethod, String swingMethod) {
        this.delegate = delegate;
        this.backendMethod = backendMethod;
        this.swingMethod = swingMethod;
        this.data = new Object[1];
    }

    public BackendWorkDelegator(Object delegate, String backendMethod, String swingMethod, Object data) {
        this.delegate = delegate;
        this.backendMethod = backendMethod;
        this.swingMethod = swingMethod;
        this.data = new Object[]{null, data};
    }

    public BackendWorkDelegator(Object delegate, String backendMethod, String swingMethod, Object data1, Object data2) {
        this.delegate = delegate;
        this.backendMethod = backendMethod;
        this.swingMethod = swingMethod;
        this.data = new Object[]{null, data1, data2};
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void invokeBackend(BackendOperationHandle handle) throws CanceledException, BackendException {
        try {
            this.data[0] = handle;
            this.invokeInternal(this.backendMethod, BACKEND_SIGNATURES);
        }
        catch (Throwable e) {
            if (e instanceof CanceledException) {
                throw (CanceledException)e;
            }
            if (e instanceof BackendException) {
                throw (BackendException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            LogAPI.logSevere(e);
        }
    }

    @Override
    public void invokeSwing(SwingOperationHandle handle) {
        if (this.swingMethod != null) {
            try {
                this.data[0] = handle;
                this.invokeInternal(this.swingMethod, SWING_SIGNATURES);
            }
            catch (Throwable e) {
                LogAPI.logSevere(e);
            }
        }
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        StringBuffer result = new StringBuffer(this.delegate.getClass().getName());
        result.delete(0, result.lastIndexOf(".") + 1);
        result.append('.').append(this.backendMethod).append("()");
        return result.toString();
    }

    protected void invokeInternal(String method, Class[][] signatures) throws Throwable {
        try {
            Class[] signature = null;
            for (int i = 0; i < signatures.length; ++i) {
                if (this.data.length != signatures[i].length) continue;
                signature = signatures[i];
                break;
            }
            Method m = null;
            Class<?> c = this.delegate.getClass();
            do {
                try {
                    m = c.getDeclaredMethod(method, signature);
                }
                catch (NoSuchMethodException e) {
                    c = c.getSuperclass();
                    if (c == null) {
                        throw new AssertionError((Object)e);
                    }
                }
            } while (m == null);
            m.setAccessible(true);
            m.invoke(this.delegate, this.data);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

