/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.exception;

import com.selima.framework.exception.ErrorItem;
import com.selima.framework.exception.ErrorType;
import com.selima.framework.exception.Severity;
import com.selima.framework.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class BackendException
extends Exception {
    private ErrorItem[] errorItems;

    public BackendException(String message, Severity severity, ErrorType errorType) {
        this(message, message, severity, errorType);
    }

    public BackendException(String shortMessage, String message, Severity severity, ErrorType errorType) {
        this(shortMessage, message, severity, errorType, null);
    }

    public BackendException(String message, Severity severity, ErrorType errorType, Throwable cause) {
        this(message, message, severity, errorType, cause);
    }

    public BackendException(String shortMessage, String message, Severity severity, ErrorType errorType, Throwable cause) {
        this(cause, new ErrorItem(shortMessage, message, severity, errorType));
    }

    public BackendException(ErrorItem ... errorItems) {
        this((Throwable)null, errorItems);
    }

    public BackendException(Throwable cause, ErrorItem ... errorItems) {
        super(cause);
        if (errorItems == null) {
            throw new NullPointerException();
        }
        if (errorItems.length == 0) {
            throw new IllegalArgumentException();
        }
        for (ErrorItem item : errorItems) {
            if (item != null) continue;
            throw new NullPointerException();
        }
        this.errorItems = this.sort(errorItems);
    }

    private ErrorItem[] sort(ErrorItem[] unsorted) {
        ArrayList<ErrorItem> terminal = new ArrayList<ErrorItem>();
        ArrayList<ErrorItem> rejectionDataType = new ArrayList<ErrorItem>();
        ArrayList<ErrorItem> rejectionOther = new ArrayList<ErrorItem>();
        ArrayList<ErrorItem> alert = new ArrayList<ErrorItem>();
        block5: for (ErrorItem item : unsorted) {
            switch (item.getSeverity()) {
                case TERMINAL: {
                    terminal.add(item);
                    continue block5;
                }
                case REJECTION: {
                    if (item.getType() == ErrorType.DATA_TYPE) {
                        rejectionDataType.add(item);
                        continue block5;
                    }
                    rejectionOther.add(item);
                    continue block5;
                }
                case ALERT: {
                    alert.add(item);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(item.toString());
                }
            }
        }
        ArrayList<ErrorItem> result = new ArrayList<ErrorItem>();
        result.addAll(terminal);
        result.addAll(rejectionDataType);
        result.addAll(rejectionOther);
        result.addAll(alert);
        return result.toArray(new ErrorItem[result.size()]);
    }

    @Override
    public String getMessage() {
        return this.getMessage(false);
    }

    public String getShortMessage() {
        return this.getMessage(true);
    }

    public String getMessage(boolean shortMessage) {
        StringBuffer terminals = new StringBuffer();
        StringBuffer rejections = new StringBuffer();
        StringBuffer alerts = new StringBuffer();
        for (ErrorItem item : this.errorItems) {
            StringBuffer buffer = null;
            switch (item.getSeverity()) {
                case TERMINAL: {
                    buffer = terminals;
                    break;
                }
                case REJECTION: {
                    buffer = rejections;
                    break;
                }
                case ALERT: {
                    buffer = alerts;
                }
            }
            if (shortMessage) {
                buffer.append(item.getShortMessage());
            } else {
                buffer.append(item.getMessage());
            }
            buffer.append("\n");
        }
        StringBuffer errorMessage = new StringBuffer();
        if (terminals.length() > 0) {
            errorMessage.append("Terminal Errors: \n");
            errorMessage.append(terminals);
            errorMessage.append("\n");
        }
        if (rejections.length() > 0) {
            errorMessage.append("Rejection Errors: \n");
            errorMessage.append(rejections);
            errorMessage.append("\n");
        }
        if (alerts.length() > 0) {
            errorMessage.append("Alert Errors: \n");
            errorMessage.append(alerts);
            errorMessage.append("\n");
        }
        return errorMessage.toString();
    }

    public Severity getSeverity() {
        Severity maxSeverity = Severity.ALERT;
        for (ErrorItem item : this.errorItems) {
            Severity severity = item.getSeverity();
            if (severity.getRank() <= maxSeverity.getRank()) continue;
            maxSeverity = severity;
        }
        return maxSeverity;
    }

    public boolean isAlert() {
        return this.getSeverity() == Severity.ALERT;
    }

    public boolean isRejection() {
        return this.getSeverity() == Severity.REJECTION;
    }

    public boolean isTerminal() {
        return this.getSeverity() == Severity.TERMINAL;
    }

    public ErrorItem[] getErrorItems() {
        return this.errorItems;
    }

    public boolean equals(Object other) {
        return other != null && other.getClass().equals(this.getClass()) && Util.equals(this.getMessage(), ((BackendException)other).getMessage());
    }

    public BackendException filter(Severity[] severities, ErrorType[] errorTypes) {
        HashSet<Severity> severitySet = new HashSet<Severity>(Arrays.asList(severities));
        HashSet<ErrorType> errorTypeSet = new HashSet<ErrorType>(Arrays.asList(errorTypes));
        ArrayList<ErrorItem> items = new ArrayList<ErrorItem>();
        for (ErrorItem item : this.getErrorItems()) {
            if (!errorTypeSet.contains((Object)item.getType()) || !severitySet.contains((Object)item.getSeverity())) continue;
            items.add(item);
        }
        if (items.size() == 0) {
            return null;
        }
        return new BackendException(items.toArray(new ErrorItem[0]));
    }

    public BackendException filter(Severity severity, ErrorType errorType) {
        return this.filter(new Severity[]{severity}, new ErrorType[]{errorType});
    }

    public BackendException filter(ErrorType[] errorTypes) {
        return this.filter(Severity.values(), errorTypes);
    }

    public BackendException filter(Severity[] severities) {
        return this.filter(severities, ErrorType.values());
    }

    public BackendException filter(Severity severity) {
        return this.filter(new Severity[]{severity});
    }

    public BackendException filter(ErrorType errorType) {
        return this.filter(new ErrorType[]{errorType});
    }

    public boolean containsAny(ErrorType[] errorTypes) {
        return this.filter(errorTypes) != null;
    }

    public boolean contains(ErrorType type) {
        return this.containsAny(new ErrorType[]{type});
    }
}

