/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.artifact;

import org.apache.commons.codec.binary.Base64;
import org.opensaml.SAMLConfig;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParseException;
import org.opensaml.artifact.SAMLArtifact;
import org.opensaml.artifact.Util;

public class SAMLArtifactType0001
extends SAMLArtifact {
    public static final Artifact.TypeCode TYPE_CODE = new SAMLArtifact.TypeCode(0, 1);

    public SAMLArtifactType0001(byte[] sourceId) {
        SAMLArtifactType0001.checkIdentifierArg(sourceId);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = new RemainingArtifact(sourceId);
    }

    public SAMLArtifactType0001(byte[] sourceId, byte[] assertionHandle) {
        SAMLArtifactType0001.checkIdentifierArg(sourceId);
        SAMLArtifactType0001.checkHandleArg(assertionHandle);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = new RemainingArtifact(sourceId, assertionHandle);
    }

    public SAMLArtifactType0001(Artifact.RemainingArtifact remainingArtifact) {
        SAMLArtifactType0001.checkNullArg(remainingArtifact);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = remainingArtifact;
    }

    public byte[] getSourceId() {
        return ((RemainingArtifact)this.remainingArtifact).getSourceId();
    }

    public byte[] getAssertionHandle() {
        return ((RemainingArtifact)this.remainingArtifact).getAssertionHandle();
    }

    public static final class Parser
    implements Artifact.Parser {
        public Artifact parse(String s) throws ArtifactParseException {
            int expectedLength;
            byte[] bytes = Base64.decodeBase64((byte[])s.getBytes());
            if (bytes.length != (expectedLength = 42)) {
                throw new ArtifactParseException(bytes.length, expectedLength);
            }
            SAMLArtifact.TypeCode typeCode = new SAMLArtifact.TypeCode(bytes[0], bytes[1]);
            if (!typeCode.equals(TYPE_CODE)) {
                throw new ArtifactParseException(typeCode, TYPE_CODE);
            }
            byte[] sourceId = new byte[20];
            System.arraycopy(bytes, 2, sourceId, 0, 20);
            byte[] assertionHandle = new byte[20];
            System.arraycopy(bytes, 22, assertionHandle, 0, 20);
            return new SAMLArtifactType0001(sourceId, assertionHandle);
        }
    }

    public static final class RemainingArtifact
    extends SAMLArtifact.RemainingArtifact {
        private byte[] sourceId;
        private byte[] assertionHandle;

        public RemainingArtifact(byte[] sourceId) {
            SAMLArtifact.checkIdentifierArg(sourceId);
            this.sourceId = sourceId;
            this.assertionHandle = SAMLConfig.instance().getDefaultIDProvider().generateRandomBytes(20);
        }

        public RemainingArtifact(byte[] sourceId, byte[] assertionHandle) {
            SAMLArtifact.checkIdentifierArg(sourceId);
            SAMLArtifact.checkHandleArg(assertionHandle);
            this.sourceId = sourceId;
            this.assertionHandle = assertionHandle;
        }

        public byte[] getSourceId() {
            return this.sourceId;
        }

        public byte[] getAssertionHandle() {
            return this.assertionHandle;
        }

        public int size() {
            return this.sourceId.length + this.assertionHandle.length;
        }

        public byte[] getBytes() {
            byte[] bytes0 = this.sourceId;
            byte[] bytes1 = this.assertionHandle;
            return Util.concat(bytes0, bytes1);
        }

        public int hashCode() {
            return this.sourceId.hashCode() & this.assertionHandle.hashCode();
        }
    }
}

