/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XML {
    protected SAMLConfig config = SAMLConfig.instance();
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String OPENSAML_NS = "http://www.opensaml.org";
    public static final String SAML_NS = "urn:oasis:names:tc:SAML:1.0:assertion";
    public static final String SAMLP_NS = "urn:oasis:names:tc:SAML:1.0:protocol";
    public static final String SAML10_PROTOCOL_ENUM = "urn:oasis:names:tc:SAML:1.0:protocol";
    public static final String SAML11_PROTOCOL_ENUM = "urn:oasis:names:tc:SAML:1.1:protocol";
    public static final String SAML_ARTIFACT_SOURCEID = "urn:oasis:names:tc:SAML:profiles:v1metadata";
    public static final String XMLSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String SOAP11ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String XML_SCHEMA_ID = "xml.xsd";
    public static final String SAML_SCHEMA_ID = "cs-sstc-schema-assertion-01.xsd";
    public static final String SAMLP_SCHEMA_ID = "cs-sstc-schema-protocol-01.xsd";
    public static final String SAML11_SCHEMA_ID = "cs-sstc-schema-assertion-1.1.xsd";
    public static final String SAMLP11_SCHEMA_ID = "cs-sstc-schema-protocol-1.1.xsd";
    public static final String XMLSIG_SCHEMA_ID = "xmldsig-core-schema.xsd";
    public static final String SOAP11ENV_SCHEMA_ID = "soap-envelope.xsd";
    private static Logger log = Logger.getLogger((String)XML.class.getName());
    public static ParserPool parserPool = new ParserPool();

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String assign(String s) {
        return s != null && s.length() > 0 ? s.trim() : null;
    }

    public static boolean safeCompare(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public static boolean isElementNamed(Element e, String ns, String localName) {
        return e != null && XML.safeCompare(ns, e.getNamespaceURI()) && XML.safeCompare(localName, e.getLocalName());
    }

    public static Element getFirstChildElement(Node n) {
        Node child;
        for (child = n.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        if (child != null) {
            return (Element)child;
        }
        return null;
    }

    public static Element getLastChildElement(Node n) {
        Node child;
        for (child = n.getLastChild(); child != null && child.getNodeType() != 1; child = child.getPreviousSibling()) {
        }
        if (child != null) {
            return (Element)child;
        }
        return null;
    }

    public static Element getFirstChildElement(Node n, String ns, String localName) {
        Element e = XML.getFirstChildElement(n);
        while (e != null && !XML.isElementNamed(e, ns, localName)) {
            e = XML.getNextSiblingElement(e);
        }
        return e;
    }

    public static Element getLastChildElement(Node n, String ns, String localName) {
        Element e = XML.getLastChildElement(n);
        while (e != null && !XML.isElementNamed(e, ns, localName)) {
            e = XML.getPreviousSiblingElement(e);
        }
        return e;
    }

    public static Element getNextSiblingElement(Node n) {
        Node sib;
        for (sib = n.getNextSibling(); sib != null && sib.getNodeType() != 1; sib = sib.getNextSibling()) {
        }
        if (sib != null) {
            return (Element)sib;
        }
        return null;
    }

    public static Element getPreviousSiblingElement(Node n) {
        Node sib;
        for (sib = n.getPreviousSibling(); sib != null && sib.getNodeType() != 1; sib = sib.getPreviousSibling()) {
        }
        if (sib != null) {
            return (Element)sib;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node n, String ns, String localName) {
        Element e = XML.getNextSiblingElement(n);
        while (e != null && !XML.isElementNamed(e, ns, localName)) {
            e = XML.getNextSiblingElement(e);
        }
        return e;
    }

    public static Element getPreviousSiblingElement(Node n, String ns, String localName) {
        Element e = XML.getPreviousSiblingElement(n);
        while (e != null && !XML.isElementNamed(e, ns, localName)) {
            e = XML.getPreviousSiblingElement(e);
        }
        return e;
    }

    public static QName getQNameAttribute(Element e, String namespace, String name) {
        String qval = XML.assign(e.getAttributeNS(namespace, name));
        if (qval == null) {
            return null;
        }
        return new QName(XML.getNamespaceForQName(qval, e), qval.substring(qval.indexOf(58) + 1));
    }

    public static QName getQNameTextNode(Text t) {
        String qval = XML.assign(t.getNodeValue());
        Node n = t.getParentNode();
        if (qval == null || n == null || n.getNodeType() != 1) {
            return null;
        }
        return new QName(XML.getNamespaceForQName(qval, (Element)n), qval.substring(qval.indexOf(58) + 1));
    }

    public static String getNamespaceForQName(String qname, Element e) {
        String prefix = null;
        if (qname != null && qname.indexOf(58) >= 0) {
            prefix = qname.substring(0, qname.indexOf(58));
        }
        return XML.getNamespaceForPrefix(prefix, e);
    }

    public static String getNamespaceForPrefix(String prefix, Element e) {
        return e.lookupNamespaceURI(prefix);
    }

    public static class ParserPool
    implements ErrorHandler,
    EntityResolver {
        protected SAMLConfig config = SAMLConfig.instance();
        private Map pools = new HashMap();
        private Stack unparsedpool = new Stack();
        private Map extensions = new HashMap();
        private Schema defaultSchema = null;
        private Schema schemaSAML10 = null;
        private Schema schemaSAML11 = null;
        private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

        public synchronized void setDefaultSchema(Schema schema) {
            this.defaultSchema = schema;
        }

        public synchronized void setDefaultSchemas(Schema schema10, Schema schema11) {
            this.schemaSAML10 = schema10;
            this.schemaSAML11 = schema11;
            this.defaultSchema = SAMLConfig.instance().getBooleanProperty("org.opensaml.compatibility-mode") ? this.schemaSAML10 : this.schemaSAML11;
        }

        public synchronized Schema getDefaultSchema() {
            return this.defaultSchema;
        }

        public synchronized Schema getSchemaSAML10() {
            return this.schemaSAML10;
        }

        public synchronized Schema getSchemaSAML11() {
            return this.schemaSAML11;
        }

        public ParserPool() {
            this.dbf.setNamespaceAware(true);
            try {
                this.dbf.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
            }
            catch (ParserConfigurationException e) {
                log.warn((Object)("Unable to turn off data normalization in parser, supersignatures may fail with Xerces-J: " + e));
            }
            this.registerSchemas(null);
        }

        public synchronized void registerSchemas(Map exts) {
            Map.Entry entry;
            if (exts != null) {
                this.extensions.putAll(exts);
            }
            SchemaFactory factory = SchemaFactory.newInstance(XML.XSD_NS);
            ArrayList<Source> sources = new ArrayList<Source>();
            sources.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xml.xsd"), XML.XML_SCHEMA_ID));
            sources.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xmldsig-core-schema.xsd"), XML.XMLSIG_SCHEMA_ID));
            sources.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/soap-envelope.xsd"), XML.SOAP11ENV_SCHEMA_ID));
            sources.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-assertion-01.xsd"), XML.SAML_SCHEMA_ID));
            sources.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-protocol-01.xsd"), XML.SAMLP_SCHEMA_ID));
            Iterator i = this.extensions.entrySet().iterator();
            while (i.hasNext()) {
                entry = i.next();
                try {
                    sources.add(new SAXSource(((EntityResolver)entry.getValue()).resolveEntity(null, (String)entry.getKey())));
                }
                catch (SAXException e) {
                    log.error((Object)("Unable to obtain extension schema (" + entry.getKey() + "): " + e));
                }
                catch (IOException e) {
                    log.error((Object)("Unable to obtain extension schema (" + entry.getKey() + "): " + e));
                }
            }
            try {
                this.schemaSAML10 = factory.newSchema(sources.toArray(new Source[0]));
            }
            catch (SAXException e) {
                log.error((Object)("Unable to parse SAML 1.0 Schemas: " + e));
            }
            sources.clear();
            sources.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xml.xsd"), XML.XML_SCHEMA_ID));
            sources.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xmldsig-core-schema.xsd"), XML.XMLSIG_SCHEMA_ID));
            sources.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/soap-envelope.xsd"), XML.SOAP11ENV_SCHEMA_ID));
            sources.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-assertion-1.1.xsd"), XML.SAML11_SCHEMA_ID));
            sources.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-protocol-1.1.xsd"), XML.SAMLP11_SCHEMA_ID));
            i = this.extensions.entrySet().iterator();
            while (i.hasNext()) {
                entry = i.next();
                try {
                    sources.add(new SAXSource(((EntityResolver)entry.getValue()).resolveEntity(null, (String)entry.getKey())));
                }
                catch (SAXException e) {
                    log.error((Object)("Unable to obtain extension schema (" + entry.getKey() + "): " + e));
                }
                catch (IOException e) {
                    log.error((Object)("Unable to obtain extension schema (" + entry.getKey() + "): " + e));
                }
            }
            try {
                this.schemaSAML11 = factory.newSchema(sources.toArray(new Source[0]));
            }
            catch (SAXException e) {
                log.error((Object)("Unable to parse SAML 1.1 Schemas: " + e));
            }
            this.defaultSchema = SAMLConfig.instance().getBooleanProperty("org.opensaml.compatibility-mode") ? this.schemaSAML10 : this.schemaSAML11;
        }

        public synchronized DocumentBuilder get(Schema schema) throws SAMLException {
            Stack pool;
            DocumentBuilder p = null;
            if (schema != null) {
                pool = (Stack)this.pools.get(schema);
                if (pool == null) {
                    pool = new Stack();
                    this.pools.put(schema, pool);
                }
            } else {
                pool = this.unparsedpool;
            }
            if (pool.empty()) {
                try {
                    this.dbf.setSchema(schema);
                    p = this.dbf.newDocumentBuilder();
                    p.setErrorHandler(this);
                    p.setEntityResolver(this);
                }
                catch (ParserConfigurationException e) {
                    log.error((Object)"Unable to obtain usable XML parser from environment");
                    throw new SAMLException("Unable to obtain usable XML parser from environment", (Exception)e);
                }
            } else {
                p = (DocumentBuilder)pool.pop();
            }
            return p;
        }

        public DocumentBuilder get() throws SAMLException {
            return this.get(this.getDefaultSchema());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document parse(InputSource in, Schema schema) throws SAMLException, SAXException, IOException {
            DocumentBuilder p = this.get(schema);
            try {
                Document doc;
                Document document = doc = p.parse(in);
                return document;
            }
            finally {
                this.put(p);
            }
        }

        public Document parse(InputStream in) throws SAMLException, SAXException, IOException {
            return this.parse(new InputSource(in), this.getDefaultSchema());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document parse(String systemId, Schema schema) throws SAMLException, SAXException, IOException {
            DocumentBuilder p = this.get(schema);
            try {
                Document doc;
                Document document = doc = p.parse(new InputSource(systemId));
                return document;
            }
            finally {
                this.put(p);
            }
        }

        public Document parse(String systemId) throws SAMLException, SAXException, IOException {
            return this.parse(systemId, this.getDefaultSchema());
        }

        public Document newDocument() {
            DocumentBuilder p = null;
            try {
                p = this.get();
            }
            catch (SAMLException e) {
                return null;
            }
            Document doc = p.newDocument();
            this.put(p);
            return doc;
        }

        public synchronized void put(DocumentBuilder p) {
            Schema schema = p.getSchema();
            if (schema == null) {
                this.unparsedpool.push(p);
            } else {
                Stack pool = (Stack)this.pools.get(schema);
                pool.push(p);
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXParseException {
            log.warn((Object)("Parser warning: line = " + e.getLineNumber() + " : uri = " + e.getSystemId()));
            log.warn((Object)("Parser warning (root cause): " + e.getMessage()));
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource();
        }
    }
}

