/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSignedObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLResponse
extends SAMLSignedObject {
    protected int minor;
    protected String responseId;
    protected String inResponseTo;
    protected Date issueInstant;
    protected String recipient;
    protected ArrayList assertions;
    protected SAMLException e;

    protected void insertSignature() throws SAMLException {
        this.root.insertBefore(this.getSignatureElement(), this.root.getFirstChild());
    }

    public SAMLResponse() {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.responseId = null;
        this.inResponseTo = null;
        this.issueInstant = new Date();
        this.recipient = null;
        this.assertions = new ArrayList();
        this.e = null;
    }

    public SAMLResponse(String inResponseTo, String recipient, Collection assertions, SAMLException e) throws SAMLException {
        this(SAMLConfig.instance().getDefaultIDProvider().getIdentifier(), new Date(), inResponseTo, recipient, assertions, e);
    }

    public SAMLResponse(String responseId, Date issueInstant, String inResponseTo, String recipient, Collection assertions, SAMLException e) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.responseId = null;
        this.inResponseTo = null;
        this.issueInstant = new Date();
        this.recipient = null;
        this.assertions = new ArrayList();
        this.e = null;
        this.responseId = XML.assign(responseId);
        this.issueInstant = issueInstant;
        this.inResponseTo = XML.assign(inResponseTo);
        this.recipient = XML.assign(recipient);
        if (e != null) {
            this.e = e.setParent(this);
        }
        if (assertions != null) {
            Iterator i = assertions.iterator();
            while (i.hasNext()) {
                this.assertions.add(((SAMLAssertion)i.next()).setParent(this));
            }
        }
    }

    public SAMLResponse(Element e) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.responseId = null;
        this.inResponseTo = null;
        this.issueInstant = new Date();
        this.recipient = null;
        this.assertions = new ArrayList();
        this.e = null;
        this.fromDOM(e);
    }

    public SAMLResponse(InputStream in) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.responseId = null;
        this.inResponseTo = null;
        this.issueInstant = new Date();
        this.recipient = null;
        this.assertions = new ArrayList();
        this.e = null;
        this.fromDOM(SAMLResponse.fromStream(in));
    }

    public SAMLResponse(InputStream in, int minor) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.responseId = null;
        this.inResponseTo = null;
        this.issueInstant = new Date();
        this.recipient = null;
        this.assertions = new ArrayList();
        this.e = null;
        this.fromDOM(SAMLResponse.fromStream(in, minor));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Response")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLResponse.fromDOM() requires samlp:Response at root");
        }
        if (Integer.parseInt(e.getAttributeNS(null, "MajorVersion")) != 1) {
            throw new MalformedException(SAMLException.VERSION, "SAMLResponse() detected incompatible response major version of " + e.getAttributeNS(null, "MajorVersion"));
        }
        this.minor = Integer.parseInt(e.getAttributeNS(null, "MinorVersion"));
        this.responseId = XML.assign(e.getAttributeNS(null, "ResponseID"));
        if (this.minor > 0) {
            e.setIdAttributeNode(e.getAttributeNodeNS(null, "ResponseID"), true);
        }
        this.inResponseTo = XML.assign(e.getAttributeNS(null, "InResponseTo"));
        this.recipient = XML.assign(e.getAttributeNS(null, "Recipient"));
        try {
            SimpleDateFormat formatter = null;
            String dateTime = XML.assign(e.getAttributeNS(null, "IssueInstant"));
            int dot = dateTime.indexOf(46);
            formatter = dot > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.issueInstant = formatter.parse(dateTime);
        }
        catch (ParseException ex) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLResponse() detected an invalid datetime while parsing response", (Exception)ex);
        }
        Element n = XML.getFirstChildElement(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Status");
        this.e = SAMLException.getInstance(n);
        Iterator it = this.e.getCodes();
        if (it.hasNext() && !it.next().equals(SAMLException.SUCCESS)) {
            throw this.e;
        }
        n = XML.getNextSiblingElement(n, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        while (n != null) {
            this.assertions.add(new SAMLAssertion(n).setParent(this));
            n = XML.getNextSiblingElement(n, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        }
        this.checkValidity();
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(int minor) {
        this.minor = minor;
        this.setDirty(true);
    }

    public String getId() {
        return this.responseId;
    }

    public void setId(String id) {
        if (XML.isEmpty(id)) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.responseId = XML.assign(id);
        this.setDirty(true);
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public void setInResponseTo(String inResponseTo) {
        this.inResponseTo = XML.assign(inResponseTo);
        this.setDirty(true);
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date issueInstant) {
        if (issueInstant == null) {
            throw new IllegalArgumentException("issueInstant cannot be null");
        }
        this.issueInstant = issueInstant;
        this.setDirty(true);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = XML.assign(recipient);
        this.setDirty(true);
    }

    public Iterator getAssertions() {
        return this.assertions.iterator();
    }

    public void setAssertions(Collection assertions) throws SAMLException {
        this.assertions.clear();
        if (assertions != null) {
            Iterator i = assertions.iterator();
            while (i.hasNext()) {
                this.assertions.add(((SAMLAssertion)i.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addAssertion(SAMLAssertion assertion) throws SAMLException {
        if (assertion == null) {
            throw new IllegalArgumentException("assertion cannot be null");
        }
        this.assertions.add(assertion.setParent(this));
        this.setDirty(true);
    }

    public void removeAssertion(int index) throws IndexOutOfBoundsException {
        this.assertions.remove(index);
        this.setDirty(true);
    }

    public SAMLException getStatus() {
        return this.e;
    }

    public void setStatus(SAMLException e) throws SAMLException {
        this.e = e.setParent(this);
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element r = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Response");
        if (xmlns) {
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        }
        return r;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element r = (Element)this.root;
        if (this.dirty) {
            if (this.responseId == null) {
                this.responseId = this.config.getDefaultIDProvider().getIdentifier();
            }
            if (this.issueInstant == null) {
                this.issueInstant = new Date();
            }
            r.setAttributeNS(null, "MajorVersion", "1");
            r.setAttributeNS(null, "MinorVersion", String.valueOf(this.minor));
            r.setAttributeNS(null, "ResponseID", this.responseId);
            if (this.minor > 0) {
                r.setIdAttributeNS(null, "ResponseID", true);
            }
            if (!XML.isEmpty(this.inResponseTo)) {
                r.setAttributeNS(null, "InResponseTo", this.inResponseTo);
            }
            if (!XML.isEmpty(this.recipient)) {
                r.setAttributeNS(null, "Recipient", this.recipient);
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            r.setAttributeNS(null, "IssueInstant", formatter.format(this.issueInstant));
            if (this.e != null) {
                r.appendChild(this.e.toDOM(doc, false));
            } else {
                Element status = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Status");
                Element code = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
                code.setAttributeNS(null, "Value", "samlp:" + SAMLException.SUCCESS.getLocalPart());
                status.appendChild(code);
                r.appendChild(status);
            }
            Iterator i = this.assertions.iterator();
            while (i.hasNext()) {
                r.appendChild(((SAMLAssertion)i.next()).toDOM(doc));
            }
            this.setDirty(false);
        } else if (xmlns) {
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (this.responseId == null) {
            throw new MalformedException("Response is invalid, must have an ID");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLResponse dup = (SAMLResponse)super.clone();
        try {
            if (this.e != null) {
                dup.e = ((SAMLException)this.e.clone()).setParent(dup);
            }
            dup.assertions = new ArrayList();
            Iterator i = this.assertions.iterator();
            while (i.hasNext()) {
                dup.assertions.add(((SAMLAssertion)((SAMLAssertion)i.next()).clone()).setParent(dup));
            }
        }
        catch (SAMLException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return dup;
    }
}

