/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.opensaml.ExpiredAssertionException;
import org.opensaml.FatalProfileException;
import org.opensaml.InvalidAssertionException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAudienceRestrictionCondition;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;

public class SAMLPOSTProfile {
    private static Logger log = Logger.getLogger((String)SAMLPOSTProfile.class.getName());
    private static TreeMap replayExpMap = new TreeMap();
    private static HashSet replayCache = new HashSet();

    public static SAMLAssertion getSSOAssertion(SAMLResponse r, Collection audiences) throws SAMLException {
        int acount = 0;
        boolean bExpired = false;
        Iterator assertions = r.getAssertions();
        block0: while (assertions.hasNext()) {
            ++acount;
            bExpired = false;
            SAMLAssertion a = (SAMLAssertion)assertions.next();
            Date notBefore = a.getNotBefore();
            Date notOnOrAfter = a.getNotOnOrAfter();
            if (notBefore == null || notOnOrAfter == null) continue;
            if (notBefore.getTime() - 300000L > System.currentTimeMillis()) {
                bExpired = true;
                continue;
            }
            if (notOnOrAfter.getTime() + 300000L <= System.currentTimeMillis()) {
                bExpired = true;
                continue;
            }
            Iterator conditions = a.getConditions();
            while (conditions.hasNext()) {
                SAMLCondition c = (SAMLCondition)conditions.next();
                if (c instanceof SAMLAudienceRestrictionCondition && ((SAMLAudienceRestrictionCondition)c).eval(audiences)) continue;
                continue block0;
            }
            Iterator statements = a.getStatements();
            while (statements.hasNext()) {
                SAMLStatement s = (SAMLStatement)statements.next();
                if (!(s instanceof SAMLAuthenticationStatement)) continue;
                SAMLSubject subject = ((SAMLAuthenticationStatement)s).getSubject();
                Iterator methods = subject.getConfirmationMethods();
                while (methods.hasNext()) {
                    if (!((String)methods.next()).equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) continue;
                    return a;
                }
            }
        }
        if (bExpired && acount == 1) {
            throw new ExpiredAssertionException(SAMLException.RESPONDER, "SAMLPOSTProfile.getSSOAssertion() unable to find a SSO assertion with valid time condition");
        }
        throw new FatalProfileException(SAMLException.RESPONDER, "SAMLPOSTProfile.getSSOAssertion() unable to find a valid SSO assertion");
    }

    public static SAMLAuthenticationStatement getSSOStatement(SAMLAssertion a) throws SAMLException {
        Iterator statements = a.getStatements();
        while (statements.hasNext()) {
            SAMLStatement s = (SAMLStatement)statements.next();
            if (!(s instanceof SAMLAuthenticationStatement)) continue;
            SAMLSubject subject = ((SAMLAuthenticationStatement)s).getSubject();
            Iterator methods = subject.getConfirmationMethods();
            while (methods.hasNext()) {
                if (!((String)methods.next()).equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) continue;
                return (SAMLAuthenticationStatement)s;
            }
        }
        throw new FatalProfileException(SAMLException.RESPONDER, "SAMLPOSTProfile.getSSOStatement() unable to find a valid SSO statement");
    }

    public static synchronized boolean checkReplayCache(SAMLAssertion a) {
        Set<Date> trash = replayExpMap.headMap(new Date()).keySet();
        Iterator<Date> i = trash.iterator();
        while (i.hasNext()) {
            replayCache.remove(replayExpMap.get(i.next()));
        }
        trash.clear();
        if (!replayCache.add(a.getId())) {
            return false;
        }
        Date expires = new Date(a.getNotOnOrAfter().getTime() + 300000L);
        while (replayExpMap.containsKey(expires)) {
            expires.setTime(expires.getTime() + 1L);
        }
        replayExpMap.put(expires, a.getId());
        return true;
    }

    public static SAMLResponse accept(byte[] buf, String receiver, int ttlSeconds, boolean process) throws SAMLException {
        try {
            SAMLResponse r = new SAMLResponse(new ByteArrayInputStream(Base64.decode((byte[])buf)));
            if (process) {
                SAMLPOSTProfile.process(r, receiver, ttlSeconds);
            }
            return r;
        }
        catch (Base64DecodingException e) {
            throw new InvalidAssertionException(SAMLException.REQUESTER, "SAMLPOSTProfile.accept() unable to decode base64 response");
        }
    }

    public static void process(SAMLResponse r, String receiver, int ttlSeconds) throws SAMLException {
        if (receiver == null || receiver.length() == 0 || !receiver.equals(r.getRecipient())) {
            throw new InvalidAssertionException(SAMLException.REQUESTER, "SAMLPOSTProfile.accept() detected recipient mismatch: " + r.getRecipient());
        }
        if (r.getIssueInstant().getTime() + (long)(1000 * ttlSeconds) + 300000L < System.currentTimeMillis()) {
            throw new ExpiredAssertionException(SAMLException.RESPONDER, "SAMLPOSTProfile.accept() detected expired response");
        }
    }

    public static SAMLResponse prepare(String recipient, String issuer, Collection audiences, String name, String nameQualifier, String format, String subjectIP, String authMethod, Date authInstant, Collection bindings) throws SAMLException {
        return SAMLPOSTProfile.prepare(recipient, issuer, audiences, new SAMLNameIdentifier(name, nameQualifier, format), subjectIP, authMethod, authInstant, bindings);
    }

    public static SAMLResponse prepare(String recipient, String issuer, Collection audiences, SAMLNameIdentifier nameId, String subjectIP, String authMethod, Date authInstant, Collection bindings) throws SAMLException {
        log.info((Object)"Creating SAML Response.");
        if (recipient == null || recipient.length() == 0) {
            throw new SAMLException(SAMLException.RESPONDER, "SAMLPOSTProfile.prepare() requires recipient");
        }
        Vector<SAMLAudienceRestrictionCondition> conditions = new Vector<SAMLAudienceRestrictionCondition>(1);
        if (audiences != null && audiences.size() > 0) {
            conditions.add(new SAMLAudienceRestrictionCondition(audiences));
        }
        String[] confirmationMethods = new String[]{"urn:oasis:names:tc:SAML:1.0:cm:bearer"};
        SAMLSubject subject = new SAMLSubject(nameId, Arrays.asList(confirmationMethods), null, null);
        SAMLStatement[] statements = new SAMLStatement[]{new SAMLAuthenticationStatement(subject, authMethod, authInstant, subjectIP, null, bindings)};
        SAMLAssertion[] assertions = new SAMLAssertion[]{new SAMLAssertion(issuer, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 300000L), conditions, null, Arrays.asList(statements))};
        return new SAMLResponse(null, recipient, Arrays.asList(assertions), null);
    }
}

