/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.opensaml.MalformedException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class SAMLObject
implements Cloneable {
    protected SAMLConfig config = SAMLConfig.instance();
    protected Node root = null;
    protected Logger log = Logger.getLogger(this.getClass());
    protected SAMLObject parentObject = null;
    protected boolean dirty = true;

    protected void setDirty(boolean flag) {
        this.dirty = flag;
        if (flag && this.parentObject != null) {
            this.parentObject.setDirty(flag);
        }
    }

    protected static Element fromStream(InputStream in) throws SAMLException {
        try {
            Document doc = XML.parserPool.parse(in);
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            NDC.push((String)"fromStream");
            Logger.getLogger((String)SAMLObject.class.getName()).error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLObject.fromStream() caught exception while parsing a stream", e);
        }
    }

    protected static Element fromStream(InputStream in, int minor) throws SAMLException {
        try {
            Document doc = XML.parserPool.parse(new InputSource(in), minor == 1 ? XML.parserPool.getSchemaSAML11() : XML.parserPool.getSchemaSAML10());
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            NDC.push((String)"fromStream");
            Logger.getLogger((String)SAMLObject.class.getName()).error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLObject.fromStream() caught exception while parsing a stream", e);
        }
    }

    protected Node plantRoot() {
        if (this.root != null) {
            Node domroot = this.root;
            while (domroot.getParentNode() != null && domroot.getParentNode().getNodeType() != 9) {
                domroot = domroot.getParentNode();
            }
            Element e = this.root.getOwnerDocument().getDocumentElement();
            if (e != null && e != domroot) {
                this.root.getOwnerDocument().replaceChild(domroot, e);
            } else if (e == null) {
                this.root.getOwnerDocument().appendChild(domroot);
            }
        }
        return this.root;
    }

    protected abstract Element buildRoot(Document var1, boolean var2);

    public abstract void checkValidity() throws SAMLException;

    public SAMLObject setParent(SAMLObject parent) throws SAMLException {
        if (this.parentObject != null) {
            throw new SAMLException("SAMLObject.setParent() called on an already-contained object");
        }
        if (parent == null) {
            throw new IllegalArgumentException("SAMLObject.setParent() called with null parameter");
        }
        this.parentObject = parent;
        return this;
    }

    public SAMLObject getParent() {
        return this.parentObject;
    }

    public void fromDOM(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException("SAMLObject.fromDOM() given an empty DOM");
        }
        this.root = e;
        this.setDirty(false);
    }

    public void toStream(OutputStream out) throws IOException, SAMLException {
        try {
            this.toDOM();
            this.plantRoot();
            Canonicalizer c = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
            out.write(c.canonicalizeSubtree(this.root, this.config.getProperty("org.opensaml.inclusive-namespace-prefixes")));
        }
        catch (InvalidCanonicalizerException e) {
            throw new IOException(e.getMessage());
        }
        catch (CanonicalizationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public byte[] toBase64() throws IOException, SAMLException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.toStream(out);
        return Base64.encodeBase64Chunked((byte[])out.toByteArray());
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        this.checkValidity();
        if (this.root != null) {
            if (!this.dirty) {
                if (this.root.getOwnerDocument() != doc) {
                    this.root = doc.adoptNode(this.root);
                    return this.root;
                }
                return this.root;
            }
            this.log.debug((Object)"toDOM() detected object changes, rebuilding tree");
        }
        this.root = this.buildRoot(doc, xmlns);
        return this.root;
    }

    public Node toDOM(boolean xmlns) throws SAMLException {
        if (this.root != null) {
            return this.toDOM(this.root.getOwnerDocument(), xmlns);
        }
        return this.toDOM(XML.parserPool.newDocument(), xmlns);
    }

    public Node toDOM(Document doc) throws SAMLException {
        return this.toDOM(doc, true);
    }

    public Node toDOM() throws SAMLException {
        return this.toDOM(true);
    }

    protected Object clone() throws CloneNotSupportedException {
        SAMLObject dup = (SAMLObject)super.clone();
        dup.root = null;
        dup.parentObject = null;
        dup.dirty = true;
        return dup;
    }

    public String toString() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.toStream(os);
            return os.toString("UTF8");
        }
        catch (IOException e) {
            NDC.push((String)"toString");
            this.log.error((Object)("caught an I/O exception while serializing XML: " + e));
            NDC.pop();
            return "";
        }
        catch (SAMLException e) {
            NDC.push((String)"toString");
            this.log.error((Object)("caught a SAML exception while serializing XML: " + e));
            NDC.pop();
            return "";
        }
    }
}

