/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.opensaml.MalformedException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLException
extends Exception
implements Cloneable {
    public static final QName SUCCESS = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "Success");
    public static final QName REQUESTER = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "Requester");
    public static final QName RESPONDER = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "Responder");
    public static final QName VERSION = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "VersionMismatch");
    protected String msg = null;
    protected Exception e = null;
    protected ArrayList codes = new ArrayList();
    protected Node root = null;
    protected SAMLObject parentObject = null;
    protected Logger log = Logger.getLogger(this.getClass());
    protected SAMLConfig config = SAMLConfig.instance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAMLException getInstance(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException(RESPONDER, "SAMLException.getInstance() given an empty DOM");
        }
        try {
            String className;
            Element eclass;
            Element detail = XML.getLastChildElement(e, "urn:oasis:names:tc:SAML:1.0:protocol", "StatusDetail");
            if (detail != null && (eclass = XML.getFirstChildElement(detail, "http://www.opensaml.org", "ExceptionClass")) != null && eclass.getFirstChild() != null && eclass.getFirstChild().getNodeType() == 3 && (className = eclass.getFirstChild().getNodeValue()) != null && className.length() > 0) {
                Class<?> implementation = Class.forName(className);
                Class[] paramtypes = new Class[]{Class.forName("org.w3c.dom.Element")};
                Object[] params = new Object[]{e};
                Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
                SAMLException sAMLException = (SAMLException)ctor.newInstance(params);
                return sAMLException;
            }
        }
        catch (ClassNotFoundException ex) {
            Category.getInstance((String)"SAMLException").error((Object)("unable to locate implementation class for exception: " + ex.getMessage()));
        }
        catch (NoSuchMethodException ex) {
            Category.getInstance((String)"SAMLException").error((Object)("unable to bind to constructor for exception: " + ex.getMessage()));
        }
        catch (InstantiationException ex) {
            Category.getInstance((String)"SAMLException").error((Object)("unable to build implementation object for exception: " + ex.getMessage()));
        }
        catch (IllegalAccessException ex) {
            Category.getInstance((String)"SAMLException").error((Object)("unable to access implementation of exception: " + ex.getMessage()));
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            Category.getInstance((String)"SAMLException").error((Object)("caught unknown exception while building exception object: " + ex.getTargetException().getMessage()));
        }
        finally {
            NDC.pop();
        }
        return new SAMLException(e);
    }

    public static SAMLException getInstance(InputStream in) throws SAMLException {
        try {
            Document doc = XML.parserPool.parse(in);
            return SAMLException.getInstance(doc.getDocumentElement());
        }
        catch (SAXException e) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLException").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLException.getInstance() caught exception while parsing a stream", (Exception)e);
        }
        catch (IOException e) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLException").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLException.getInstance() caught exception while parsing a stream", (Exception)e);
        }
    }

    protected SAMLException(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLException(String msg) {
        super(msg);
        this.msg = msg;
    }

    public SAMLException(String msg, Exception e) {
        super(msg, e);
        this.msg = msg;
        this.e = e;
    }

    public SAMLException(Collection codes) {
        if (codes != null) {
            this.codes.addAll(codes);
        }
    }

    public SAMLException(Collection codes, String msg) {
        super(msg);
        this.msg = msg;
        if (codes != null) {
            this.codes.addAll(codes);
        }
    }

    public SAMLException(Collection codes, Exception e) {
        super(e);
        this.e = e;
        if (codes != null) {
            this.codes.addAll(codes);
        }
    }

    public SAMLException(Collection codes, String msg, Exception e) {
        super(msg, e);
        this.msg = msg;
        this.e = e;
        if (codes != null) {
            this.codes.addAll(codes);
        }
    }

    public SAMLException(QName code) {
        if (code != null) {
            this.codes.add(code);
        }
    }

    public SAMLException(QName code, String msg) {
        super(msg);
        this.msg = msg;
        if (code != null) {
            this.codes.add(code);
        }
    }

    public SAMLException(QName code, Exception e) {
        super(e);
        this.e = e;
        if (code != null) {
            this.codes.add(code);
        }
    }

    public SAMLException(QName code, String msg, Exception e) {
        super(msg, e);
        this.msg = msg;
        this.e = e;
        if (code != null) {
            this.codes.add(code);
        }
    }

    public SAMLException setParent(SAMLObject parent) throws SAMLException {
        if (this.parentObject != null) {
            throw new SAMLException("SAMLObject.setParent() called on an already-contained object");
        }
        if (parent == null) {
            throw new IllegalArgumentException("SAMLObject.setParent() called with null parameter");
        }
        this.parentObject = parent;
        return this;
    }

    public SAMLObject getParent() {
        return this.parentObject;
    }

    public void fromDOM(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException("SAMLException.fromDOM() given an empty DOM");
        }
        this.root = e;
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Status")) {
            throw new MalformedException(RESPONDER, "SAMLException.fromDOM() requires samlp:Status at root");
        }
        Element m = XML.getFirstChildElement(e, "urn:oasis:names:tc:SAML:1.0:protocol", "StatusMessage");
        if (m != null && m.getFirstChild() != null) {
            this.msg = m.getFirstChild().getNodeValue();
        }
        NodeList nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
        for (int i = 0; nlist != null && i < nlist.getLength(); ++i) {
            QName qptr = XML.getQNameAttribute((Element)nlist.item(i), null, "Value");
            if (qptr == null) {
                throw new MalformedException(RESPONDER, "SAMLException.fromDOM() unable to evaluate QName Value");
            }
            this.codes.add(qptr);
        }
    }

    public void toStream(OutputStream out) throws IOException, SAMLException {
        try {
            Canonicalizer c = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
            out.write(c.canonicalizeSubtree(this.toDOM()));
        }
        catch (InvalidCanonicalizerException e) {
            throw new IOException(e.getMessage());
        }
        catch (CanonicalizationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        if (this.root != null) {
            if (this.root.getOwnerDocument() != doc) {
                this.root = doc.adoptNode(this.root);
            }
        } else {
            Element s = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Status");
            s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            if (this.codes == null || this.codes.isEmpty()) {
                Element sc = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
                sc.setAttributeNS(null, "Value", "samlp:" + RESPONDER.getLocalPart());
                s.appendChild(sc);
            } else {
                Node base = s;
                Iterator i = this.codes.iterator();
                while (i.hasNext()) {
                    QName qcode = (QName)i.next();
                    Element sc = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
                    String codens = qcode.getNamespaceURI();
                    if (!codens.equals("urn:oasis:names:tc:SAML:1.0:protocol")) {
                        sc.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:code", codens);
                        codens = "code:";
                    } else {
                        codens = "samlp:";
                    }
                    sc.setAttributeNS(null, "Value", codens + qcode.getLocalPart());
                    base = base.appendChild(sc);
                }
            }
            if (!XML.isEmpty(this.getMessage())) {
                Element msg = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusMessage");
                msg.appendChild(doc.createTextNode(this.getMessage()));
                s.appendChild(msg);
            }
            if (!(this instanceof SAMLException)) {
                Element detail = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusDetail");
                detail.appendChild(doc.createElementNS("http://www.opensaml.org", "ExceptionClass")).appendChild(doc.createTextNode(this.getClass().getName()));
            }
            this.root = s;
        }
        if (xmlns) {
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        return this.root;
    }

    public Node toDOM(boolean xmlns) throws SAMLException {
        if (this.root != null) {
            return this.root;
        }
        return this.toDOM(XML.parserPool.newDocument(), xmlns);
    }

    public Node toDOM(Document doc) throws SAMLException {
        return this.toDOM(doc, true);
    }

    public Node toDOM() throws SAMLException {
        return this.toDOM(true);
    }

    public Iterator getCodes() {
        return this.codes.iterator();
    }

    public String getMessage() {
        if (this.msg != null && this.e != null) {
            return this.msg + " (wrapped: " + this.e.getMessage() + ')';
        }
        if (this.e != null) {
            return "(wrapped: " + this.e.getMessage() + ")";
        }
        return this.msg;
    }

    public Exception getException() {
        return this.e;
    }

    public String toString() {
        return this.e != null ? this.e.toString() : super.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLException dup = (SAMLException)super.clone();
        dup.codes = (ArrayList)this.codes.clone();
        dup.root = null;
        dup.parentObject = null;
        return dup;
    }
}

