/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthorityBinding
extends SAMLObject
implements Cloneable {
    protected String binding = null;
    protected String location = null;
    protected QName authorityKind = null;

    public SAMLAuthorityBinding() {
    }

    public SAMLAuthorityBinding(String binding, String location, QName authorityKind) throws SAMLException {
        this.binding = XML.assign(binding);
        this.location = XML.assign(location);
        this.authorityKind = authorityKind;
    }

    public SAMLAuthorityBinding(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAuthorityBinding(InputStream in) throws SAMLException {
        this.fromDOM(SAMLAuthorityBinding.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthorityBinding() requires saml:AuthorityBinding at root");
        }
        this.binding = XML.assign(e.getAttributeNS(null, "Binding"));
        this.location = XML.assign(e.getAttributeNS(null, "Location"));
        this.authorityKind = XML.getQNameAttribute(e, null, "AuthorityKind");
        this.checkValidity();
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        if (XML.isEmpty(binding)) {
            throw new IllegalArgumentException("binding cannot be null or empty");
        }
        this.binding = binding;
        this.setDirty(true);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        if (XML.isEmpty(location)) {
            throw new IllegalArgumentException("location cannot be null or empty");
        }
        this.location = location;
        this.setDirty(true);
    }

    public QName getAuthorityKind() {
        return this.authorityKind;
    }

    public void setAuthorityKind(QName authorityKind) {
        if (authorityKind == null) {
            throw new IllegalArgumentException("authorityKind cannot be null");
        }
        this.authorityKind = authorityKind;
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element ab = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
        if (xmlns) {
            ab.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return ab;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element ab = (Element)this.root;
        if (this.dirty) {
            ab.setAttributeNS(null, "Binding", this.binding);
            ab.setAttributeNS(null, "Location", this.location);
            if (!"urn:oasis:names:tc:SAML:1.0:protocol".equals(this.authorityKind.getNamespaceURI())) {
                ab.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:kind", this.authorityKind.getNamespaceURI());
                ab.setAttributeNS(null, "AuthorityKind", "kind:" + this.authorityKind.getLocalPart());
            } else {
                ab.setAttributeNS(null, "AuthorityKind", "samlp:" + this.authorityKind.getLocalPart());
            }
            this.setDirty(false);
        } else if (xmlns) {
            ab.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.binding) || XML.isEmpty(this.location) || this.authorityKind == null) {
            throw new MalformedException("AuthorityBinding is invalid, must have Binding, Location, and AuthorityKind");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

