/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.lang.reflect.Constructor;
import org.opensaml.NoSuchProviderException;
import org.opensaml.ReplayCache;
import org.opensaml.SAMLConfig;
import org.w3c.dom.Element;

public class ReplayCacheFactory {
    public static ReplayCache getInstance() throws NoSuchProviderException {
        return ReplayCacheFactory.getInstance(null, SAMLConfig.instance().getProperty("org.opensaml.provider.replaycache"));
    }

    public static ReplayCache getInstance(String provider) throws NoSuchProviderException {
        return ReplayCacheFactory.getInstance(null, provider);
    }

    public static ReplayCache getInstance(Element e) throws NoSuchProviderException {
        return ReplayCacheFactory.getInstance(e, SAMLConfig.instance().getProperty("org.opensaml.provider.replaycache"));
    }

    public static ReplayCache getInstance(Element e, String provider) throws NoSuchProviderException {
        try {
            Class<?> implementation = Class.forName(provider);
            Class[] paramtypes = new Class[]{Element.class};
            Object[] params = new Object[]{e};
            Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
            return (ReplayCache)ctor.newInstance(params);
        }
        catch (Exception ex) {
            throw new NoSuchProviderException("getInstance() unable to build instance of cache provider (" + provider + "): " + ex.getMessage(), ex);
        }
    }
}

